function finish=extract_all_objects_amc(start,finish,correct,threshold,N,frames_per_sec1)
%function finish=extract_all_objects_amc(start,finish,correct,threshold,N,frames_per_sec1)
%
%%   COPYRIGHT:  George D. Tsibidis(1) and Nektarios Tavernarakis(2)
%               (1) Institute of Electronic Structure and Laser 
%               (2) Institute of Molecular Biology and Biotechnology 
%               Foundation for Research and Technology-Hellas (FORTH)
%               January 2007
%
%
%Objective: after manual correction to the skeleton of some objects we
%apply the gollowing algorithm
%
% Input: start: first image
%        finish: final image
%       correct: use correction algorithm to see the front and the tail of
%                the object. In our case we have always to put correct=1 so
%                that we will know which one is the front and which the
%                back part of the animal
%       threshold: threshold used for images.(.4 was used in this experiment)
%       N: number of segments: (enter 7 in this experiment)
%       frames_per_sec: frames per sec (4 in this experiment)
%

%DESCRIPTION:This is a matalb file that uses machine vision to extract in an
%automated way a number of image files and data aimed to elucidate the
%movement and behaviour of C.elegans.
%

%CREATE DIRECTORIES WHERE IMAGE DATA ARE SAVED. 'DATA' DIRECTORY IS THE
%FIRST ONE WHILE 'DATA_SAVED' IS THE FINAL DIRECTORY AFTER CORRECTIONS
%ARE APPLIED TO THE IMAGES.

  [status,msg]=mkdir ('DATA_SAVED');
      cd ('DATA_SAVED');
  file2=['number_of_time_points.txt'];
        save(file2,'N', '-ascii');
          file2=['frames_per_sec.txt'];
          frames_per_sec1
        save(file2,'frames_per_sec1', '-ascii');
        cd ..
  
        
  %EXTRACT IMAGE AND DATA FILES FRM ALL IMAGES
  
for image=start:finish

   % extract_object(image,threshold);
   
        
        if image==start
        cd ('DATA_SAVED');
        first_skeleton=load(['skeleton_' int2str(start)]);
        figure;imshow(first_skeleton);
        BRC=[threshold,size(first_skeleton)];
        file2=['background_row_column.txt'];
        save(file2,'BRC', '-ascii');
 
        [c,r,p]=impixel(first_skeleton);
        A=[c(1),r(1)];B=[c(2),r(2)];
        EDGES=[A;B];
        
        cd ..
        cd ('DATA_SAVED')
        
        file2=['edge_' int2str(image) '.txt'];
        save(file2,'EDGES', '-ascii');
      
        figure;imshow(first_skeleton);hold on;plot([c(1) c(2)],[r(1) r(2)],'r.');
        cd ..
     
          numb=correct_skeleton(image,image,A,B);
       

          
      end
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%5
%%%% correct skeleton
if correct==1
for image=start+1:finish
correct_skeleton_image=image;

cd ('DATA_SAVED');
EDGES=load(['edge_' int2str(image-1) '.txt']);
A=EDGES(1,:);B=EDGES(2,:);
cd ..
    numb=[numb,correct_skeleton(image,image,A,B)];
    
end

cd ('DATA_SAVED');
file2=['image number vs number of points'];
   save(file2,'numb','-ascii');
  
end


cd ..
%%%%%%%%%%%%%%%%%%%%%%%%%5

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% segmentation of the object

cd ('DATA_SAVED')

N=load(['number_of_time_points.txt']); % which will be saved in the 'numer_of_time_points.txt' file (at the moment it is set manually)

cd ..

point_segment(N,start,finish); %segmentation of the animal
area_calculation(start,finish);   %calculation of area in pixels occupied by the annimal
length_elegans(start,finish);   %calculation of length in pixels occupied by the annimal
thickness_automatic(start,finish); %calculation of thickness 
cm_total(start,finish,N); %calculation of position of CM of the animal (taking into account the whole object except fom the first part)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


